// TriangleObject.cpp: implementation of the CTriangleObject class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "TriangleObject.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif
extern CString g_sApplicationPath;
 
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

void SObjectIndex::SetGlListObject(GLuint index)
	{
	glListObject = index;
	}

CTriangleObject::CTriangleObject()
	{
	}

CTriangleObject::~CTriangleObject()
	{
	vertex.clear();
	normal.clear();
	color.clear();
	colorindex.clear();
	for(int i=0;i<m_vpObjectIndex.size();i++)
		{
		delete m_vpObjectIndex[i];
		}
	}

void CTriangleObject::LoadTriangleFile(CString FileName)
	{
	fstream inputfile;
	
	inputfile.open(g_sApplicationPath + FileName, ios::in);
	
	if(inputfile.fail())
		{
		AfxMessageBox(FileName + " :not found");
		return;
		}

	char buffer[100]; // read a line
	
	short int nx,ny,nz;
	
	char word[20];
	
	double x,y,z;
	
	GLuint index = 0;
	
	///////////////////////////////////////////////////////////////////
	// initialise the indices
	///////////////////////////////////////////////////////////////////
	SObjectIndex *ActualIndex = new SObjectIndex;
	ActualIndex->FirstIndex=normal.size();
	ActualIndex->ColorFirst=color.size();
	ActualIndex->ColorIndexFirst=colorindex.size();
	ActualIndex->glListObject=0;
	///////////////////////////////////////////////////////////////////
	
	while (!inputfile.eof() )
		{
		//
		// read a line from the file
		//
		inputfile.getline(buffer,80);
		sscanf(buffer,"%s %lf %lf %lf",word,&x,&y,&z);

		if(!strcmp(word,"color"))
			{
			colorindex.push_back(index);
			
			color.push_back(float(x));
			color.push_back(float(y));
			color.push_back(float(z));
			}
		
		if(!strcmp(word,"normal"))
			{
			nx=(short)(x*100.);
			ny=(short)(y*100.);
			nz=(short)(z*100.);

			normal.push_back(nx);
			normal.push_back(ny);
			normal.push_back(nz);
			}
		
		if(!strcmp(word,"vertex"))
			{
			index++;
			vertex.push_back(x);
			vertex.push_back(y);
			vertex.push_back(z);
			}	
		}
	
	colorindex.push_back(index);
	
	inputfile.close();

	ActualIndex->LastIndex=normal.size();
	ActualIndex->ObjectName=FileName;
	ActualIndex->ColorIndexLast=colorindex.size();
	
	m_vpObjectIndex.push_back(ActualIndex);
	Show(FileName);
	}

void CTriangleObject::Show(CString ListName)
	{
	int i;
	int found = -1;
	//
	// searching for name in the list
	//
	for(i=0; i < m_vpObjectIndex.size(); i++)
		{
		if(m_vpObjectIndex[i]->ObjectName == ListName)
			{
			if(m_vpObjectIndex[i]->glListObject) 
				{
				//
				// call opengl stored display list
				//
				glCallList(m_vpObjectIndex[i]->glListObject);
				return;
				}
			else
				{
				//
				// new name stil no list
				//
				found = i;
				}
			}
		}
	//
	// exeption if ListName isn/t in ObjectIndex[]
	// or return I won't see anything
	//
	if(found == -1) return;
	//
	// create new list for the ListName
	//
	i = found;
	//
	// generate an unique listnumber
	//
	m_vpObjectIndex[i]->SetGlListObject(glGenLists(1));
	glNewList(m_vpObjectIndex[i]->glListObject,GL_COMPILE_AND_EXECUTE);
	
	GLuint VertexBegin,VertexEnd;
	GLuint ColorBegin;
	GLuint ColorIndexBegin,ColorIndexEnd;

	ColorBegin	=	m_vpObjectIndex[i]->ColorFirst;
	VertexBegin	=	m_vpObjectIndex[i]->FirstIndex;
	VertexEnd	=	m_vpObjectIndex[i]->LastIndex;
	
	ColorIndexBegin	=	m_vpObjectIndex[i]->ColorIndexFirst;
	ColorIndexEnd		=	m_vpObjectIndex[i]->ColorIndexLast;

	glNormalPointer(GL_SHORT,0,&normal[VertexBegin]); 
	glVertexPointer(3,GL_FLOAT,0,&vertex[VertexBegin]);

	glEnableClientState(GL_NORMAL_ARRAY);
	glEnableClientState(GL_VERTEX_ARRAY);
	//
	// if the file is empty then return
	//
	if (VertexEnd - VertexBegin < 1) return;
	
	GLfloat pathcolor[4];

	for(int k = ColorIndexBegin,j = ColorBegin; k < ColorIndexEnd - 1; k++, j+=3)
		{
		pathcolor[0] = color[j];
		pathcolor[1] = color[j+1];
		pathcolor[2] = color[j+2];
	 
		glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, pathcolor);
		glDrawArrays(GL_TRIANGLES,colorindex[k], colorindex[k+1] - colorindex[k]);
		}
			
	glEndList();	
	}



